/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef _B_SERIAL_H_
#define _B_SERIAL_H_

#include <typedefs.h>
#include "b_io.h"

extern b_handlestype handle_array[];    /*lint !e762 redundant declaration */

/* --------------------------------------------------------------------------
 * These declarations are common to all OS's.  Note that the meaning of 
 * OsHandle is OS-dependent.
 * -------------------------------------------------------------------------- */

#define SER_RCV_TIMEOUT   600000UL

b_portnumtype BestOpenCOMInitial(int num, b_int32 baudrate);

void BestCloseSerial(b_portnumtype portnumber);

/* BestSerSetRegwidth() not needed */
b_errtype BestSerDeviceConnect(b_portnumtype OsHandle);
b_errtype BestSerCheckConnection(b_portnumtype OsHandle);
void BestSerReleaseConnection(b_portnumtype OsHandle);

b_errtype BestSerOnReadOrWriteError(b_portnumtype OsHandle);
b_errtype BestSerPortTimeoutSet(b_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts);

/* Default timeouts are defined in b_io.h */

/* --------------------------------------------------------------------------
 * These declarations are not always used (OS-DEPENDENT)
 * -------------------------------------------------------------------------- */

b_errtype BestSerBasicRead(
    b_handletype handle,
    b_int8ptr pData,
    b_int32 NumBytes,
    b_int32 * NumBytesRead);

b_errtype BestSerBasicWrite(
    b_handletype handle,
    b_int8ptr pData,
    b_int32 NumBytes,
    b_int32 * NumBytesWritten);

#endif /* _B_SERIAL_H_ */
